package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationSettingsRequest(
    applicationName: ApplicationName,
    templateName: Option[ConfigurationTemplateName] = None,
    environmentName: Option[EnvironmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest = {
    import DescribeConfigurationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest(
        applicationName,
        templateName.map(value => value),
        environmentName.map(value => value)
      )
    def applicationName: ApplicationName
    def templateName: Option[ConfigurationTemplateName]
    def environmentName: Option[EnvironmentName]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
