package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  Token,
  MaxRecords,
  VersionLabel,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationVersionsRequest(
    applicationName: Option[ApplicationName] = None,
    versionLabels: Option[Iterable[VersionLabel]] = None,
    maxRecords: Option[MaxRecords] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest = {
    import DescribeApplicationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabels.map(value =>
          value.map { item =>
            VersionLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionLabels)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest(
        applicationName.map(value => value),
        versionLabels.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def versionLabels: Option[List[VersionLabel]]
    def maxRecords: Option[MaxRecords]
    def nextToken: Option[Token]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabels: ZIO[Any, AwsError, List[VersionLabel]] =
      AwsError.unwrapOptionField("versionLabels", versionLabels)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val versionLabels: Option[List[VersionLabel]] = scala
      .Option(impl.versionLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.VersionLabel(item)
        }.toList
      )
    override val maxRecords: Option[MaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.MaxRecords(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
