package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Queue(
    name: Option[String] = None,
    url: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Queue = {
    import Queue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Queue
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Queue.ReadOnly =
    zio.aws.elasticbeanstalk.model.Queue.wrap(buildAwsValue())
}
object Queue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Queue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Queue =
      zio.aws.elasticbeanstalk.model
        .Queue(name.map(value => value), url.map(value => value))
    def name: Option[String]
    def url: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Queue
  ) extends zio.aws.elasticbeanstalk.model.Queue.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Queue
  ): zio.aws.elasticbeanstalk.model.Queue.ReadOnly = new Wrapper(impl)
}
