package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{S3Key, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    s3Bucket: Option[S3Bucket] = None,
    s3Key: Option[S3Key] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.S3Location
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.S3Location.ReadOnly =
    zio.aws.elasticbeanstalk.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.S3Location =
      zio.aws.elasticbeanstalk.model
        .S3Location(s3Bucket.map(value => value), s3Key.map(value => value))
    def s3Bucket: Option[S3Bucket]
    def s3Key: Option[S3Key]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.S3Location
  ) extends zio.aws.elasticbeanstalk.model.S3Location.ReadOnly {
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.S3Bucket(value))
    override val s3Key: Option[S3Key] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.S3Location
  ): zio.aws.elasticbeanstalk.model.S3Location.ReadOnly = new Wrapper(impl)
}
