package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigurationOptionValueType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType
}
object ConfigurationOptionValueType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType
  ): zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.SCALAR =>
      val r = Scalar
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.LIST =>
      val r = List
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object Scalar
      extends zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.SCALAR
  }
  case object List
      extends zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType.LIST
  }
}
