package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAttributesResponse(
    resourceQuotas: Option[zio.aws.elasticbeanstalk.model.ResourceQuotas] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(resourceQuotas.map(value => value.buildAwsValue()))(
        _.resourceQuotas
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse =
      zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse(
        resourceQuotas.map(value => value.asEditable)
      )
    def resourceQuotas
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly]
    def getResourceQuotas: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly
    ] = AwsError.unwrapOptionField("resourceQuotas", resourceQuotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly {
    override val resourceQuotas
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly] = scala
      .Option(impl.resourceQuotas())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuotas.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse
  ): zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
