package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApplyEnvironmentManagedActionResponse(
    actionId: Option[String] = None,
    actionDescription: Option[String] = None,
    actionType: Option[zio.aws.elasticbeanstalk.model.ActionType] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse = {
    import ApplyEnvironmentManagedActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
      .builder()
      .optionallyWith(actionId.map(value => value: java.lang.String))(
        _.actionId
      )
      .optionallyWith(actionDescription.map(value => value: java.lang.String))(
        _.actionDescription
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
      .wrap(buildAwsValue())
}
object ApplyEnvironmentManagedActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse =
      zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse(
        actionId.map(value => value),
        actionDescription.map(value => value),
        actionType.map(value => value),
        status.map(value => value)
      )
    def actionId: Option[String]
    def actionDescription: Option[String]
    def actionType: Option[zio.aws.elasticbeanstalk.model.ActionType]
    def status: Option[String]
    def getActionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionDescription", actionDescription)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ) extends zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly {
    override val actionId: Option[String] =
      scala.Option(impl.actionId()).map(value => value: String)
    override val actionDescription: Option[String] =
      scala.Option(impl.actionDescription()).map(value => value: String)
    override val actionType: Option[zio.aws.elasticbeanstalk.model.ActionType] =
      scala
        .Option(impl.actionType())
        .map(value => zio.aws.elasticbeanstalk.model.ActionType.wrap(value))
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ): zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly =
    new Wrapper(impl)
}
