package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class LoadBalancer(name: Option[ResourceId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer
      .builder()
      .optionallyWith(
        name.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly =
    zio.aws.elasticbeanstalk.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.LoadBalancer =
      zio.aws.elasticbeanstalk.model.LoadBalancer(name.map(value => value))
    def name: Option[ResourceId]
    def getName: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer
  ) extends zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly {
    override val name: Option[ResourceId] = scala
      .Option(impl.name())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer
  ): zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly = new Wrapper(impl)
}
