package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait ActionStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus
}
object ActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus
  ): zio.aws.elasticbeanstalk.model.ActionStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.SCHEDULED =>
      val r = Scheduled
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Scheduled extends zio.aws.elasticbeanstalk.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.SCHEDULED
  }
  case object Pending extends zio.aws.elasticbeanstalk.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.PENDING
  }
  case object Running extends zio.aws.elasticbeanstalk.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.RUNNING
  }
  case object Unknown extends zio.aws.elasticbeanstalk.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus.UNKNOWN
  }
}
