package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait ValidationSeverity {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity
}
object ValidationSeverity {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity
  ): zio.aws.elasticbeanstalk.model.ValidationSeverity = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.WARNING =>
      val r = warning
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ValidationSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object error extends zio.aws.elasticbeanstalk.model.ValidationSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.ERROR
  }
  case object warning
      extends zio.aws.elasticbeanstalk.model.ValidationSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity.WARNING
  }
}
