package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationVersionStatus {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus
}
object ApplicationVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus
  ): zio.aws.elasticbeanstalk.model.ApplicationVersionStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.PROCESSED =>
      val r = Processed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.UNPROCESSED =>
      val r = Unprocessed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.BUILDING =>
      val r = Building
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Processed
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.PROCESSED
  }
  case object Unprocessed
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.UNPROCESSED
  }
  case object Failed
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.FAILED
  }
  case object Processing
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.PROCESSING
  }
  case object Building
      extends zio.aws.elasticbeanstalk.model.ApplicationVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus.BUILDING
  }
}
