package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters.*
final case class EnvironmentResourceDescription(
    environmentName: Option[EnvironmentName] = None,
    autoScalingGroups: Option[
      Iterable[zio.aws.elasticbeanstalk.model.AutoScalingGroup]
    ] = None,
    instances: Option[Iterable[zio.aws.elasticbeanstalk.model.Instance]] = None,
    launchConfigurations: Option[
      Iterable[zio.aws.elasticbeanstalk.model.LaunchConfiguration]
    ] = None,
    launchTemplates: Option[
      Iterable[zio.aws.elasticbeanstalk.model.LaunchTemplate]
    ] = None,
    loadBalancers: Option[
      Iterable[zio.aws.elasticbeanstalk.model.LoadBalancer]
    ] = None,
    triggers: Option[Iterable[zio.aws.elasticbeanstalk.model.Trigger]] = None,
    queues: Option[Iterable[zio.aws.elasticbeanstalk.model.Queue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription = {
    import EnvironmentResourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        launchConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchConfigurations)
      .optionallyWith(
        launchTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplates)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queues)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription
      .wrap(buildAwsValue())
}
object EnvironmentResourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription =
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription(
        environmentName.map(value => value),
        autoScalingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def environmentName: Option[EnvironmentName]
    def autoScalingGroups
        : Option[List[zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly]]
    def instances
        : Option[List[zio.aws.elasticbeanstalk.model.Instance.ReadOnly]]
    def launchConfigurations: Option[
      List[zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly]
    ]
    def launchTemplates
        : Option[List[zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly]]
    def loadBalancers
        : Option[List[zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly]]
    def triggers: Option[List[zio.aws.elasticbeanstalk.model.Trigger.ReadOnly]]
    def queues: Option[List[zio.aws.elasticbeanstalk.model.Queue.ReadOnly]]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getLaunchConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchConfigurations", launchConfigurations)
    def getLaunchTemplates: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField("launchTemplates", launchTemplates)
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Trigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getQueues: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Queue.ReadOnly
    ]] = AwsError.unwrapOptionField("queues", queues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly {
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val autoScalingGroups: Option[
      List[zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly]
    ] = scala
      .Option(impl.autoScalingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.AutoScalingGroup.wrap(item)
        }.toList
      )
    override val instances
        : Option[List[zio.aws.elasticbeanstalk.model.Instance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Instance.wrap(item)
        }.toList
      )
    override val launchConfigurations: Option[
      List[zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly]
    ] = scala
      .Option(impl.launchConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.LaunchConfiguration.wrap(item)
        }.toList
      )
    override val launchTemplates
        : Option[List[zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly]] =
      scala
        .Option(impl.launchTemplates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.LaunchTemplate.wrap(item)
          }.toList
        )
    override val loadBalancers
        : Option[List[zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly]] =
      scala
        .Option(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val triggers
        : Option[List[zio.aws.elasticbeanstalk.model.Trigger.ReadOnly]] = scala
      .Option(impl.triggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Trigger.wrap(item)
        }.toList
      )
    override val queues
        : Option[List[zio.aws.elasticbeanstalk.model.Queue.ReadOnly]] = scala
      .Option(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Queue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ): zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly =
    new Wrapper(impl)
}
