package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ApplicationVersionProccess,
  ApplicationName,
  AutoCreateApplication,
  VersionLabel,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationVersionRequest(
    applicationName: ApplicationName,
    versionLabel: VersionLabel,
    description: Option[Description] = None,
    sourceBuildInformation: Option[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation
    ] = None,
    sourceBundle: Option[zio.aws.elasticbeanstalk.model.S3Location] = None,
    buildConfiguration: Option[
      zio.aws.elasticbeanstalk.model.BuildConfiguration
    ] = None,
    autoCreateApplication: Option[AutoCreateApplication] = None,
    process: Option[ApplicationVersionProccess] = None,
    tags: Option[Iterable[zio.aws.elasticbeanstalk.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest = {
    import CreateApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .versionLabel(VersionLabel.unwrap(versionLabel): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        sourceBuildInformation.map(value => value.buildAwsValue())
      )(_.sourceBuildInformation)
      .optionallyWith(sourceBundle.map(value => value.buildAwsValue()))(
        _.sourceBundle
      )
      .optionallyWith(buildConfiguration.map(value => value.buildAwsValue()))(
        _.buildConfiguration
      )
      .optionallyWith(
        autoCreateApplication.map(value =>
          AutoCreateApplication.unwrap(value): java.lang.Boolean
        )
      )(_.autoCreateApplication)
      .optionallyWith(
        process.map(value =>
          ApplicationVersionProccess.unwrap(value): java.lang.Boolean
        )
      )(_.process)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest =
      zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest(
        applicationName,
        versionLabel,
        description.map(value => value),
        sourceBuildInformation.map(value => value.asEditable),
        sourceBundle.map(value => value.asEditable),
        buildConfiguration.map(value => value.asEditable),
        autoCreateApplication.map(value => value),
        process.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def versionLabel: VersionLabel
    def description: Option[Description]
    def sourceBuildInformation
        : Option[zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly]
    def sourceBundle: Option[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly]
    def buildConfiguration
        : Option[zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly]
    def autoCreateApplication: Option[AutoCreateApplication]
    def process: Option[ApplicationVersionProccess]
    def tags: Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getVersionLabel: ZIO[Any, Nothing, VersionLabel] =
      ZIO.succeed(versionLabel)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSourceBuildInformation: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceBuildInformation",
      sourceBuildInformation
    )
    def getSourceBundle: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("sourceBundle", sourceBundle)
    def getBuildConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("buildConfiguration", buildConfiguration)
    def getAutoCreateApplication: ZIO[Any, AwsError, AutoCreateApplication] =
      AwsError.unwrapOptionField("autoCreateApplication", autoCreateApplication)
    def getProcess: ZIO[Any, AwsError, ApplicationVersionProccess] =
      AwsError.unwrapOptionField("process", process)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val versionLabel: VersionLabel =
      zio.aws.elasticbeanstalk.model.primitives
        .VersionLabel(impl.versionLabel())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val sourceBuildInformation: Option[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = scala
      .Option(impl.sourceBuildInformation())
      .map(value =>
        zio.aws.elasticbeanstalk.model.SourceBuildInformation.wrap(value)
      )
    override val sourceBundle
        : Option[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly] = scala
      .Option(impl.sourceBundle())
      .map(value => zio.aws.elasticbeanstalk.model.S3Location.wrap(value))
    override val buildConfiguration
        : Option[zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly] =
      scala
        .Option(impl.buildConfiguration())
        .map(value =>
          zio.aws.elasticbeanstalk.model.BuildConfiguration.wrap(value)
        )
    override val autoCreateApplication: Option[AutoCreateApplication] = scala
      .Option(impl.autoCreateApplication())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.AutoCreateApplication(value)
      )
    override val process: Option[ApplicationVersionProccess] = scala
      .Option(impl.process())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ApplicationVersionProccess(value)
      )
    override val tags
        : Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ): zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
