package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ManagedActionHistoryMaxItems,
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentManagedActionHistoryRequest(
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None,
    nextToken: Option[String] = None,
    maxItems: Option[ManagedActionHistoryMaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest = {
    import DescribeEnvironmentManagedActionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxItems.map(value =>
          ManagedActionHistoryMaxItems.unwrap(value): Integer
        )
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest =
      zio.aws.elasticbeanstalk.model
        .DescribeEnvironmentManagedActionHistoryRequest(
          environmentId.map(value => value),
          environmentName.map(value => value),
          nextToken.map(value => value),
          maxItems.map(value => value)
        )
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def nextToken: Option[String]
    def maxItems: Option[ManagedActionHistoryMaxItems]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, ManagedActionHistoryMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest.ReadOnly {
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxItems: Option[ManagedActionHistoryMaxItems] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ManagedActionHistoryMaxItems(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
