package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationsResponse(
    applications: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ApplicationDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse = {
    import DescribeApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse =
      zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applications: Option[
      List[zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly]
    ]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly {
    override val applications: Option[
      List[zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly]
    ] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ApplicationDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
