package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  TerminateEnvForce,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationRequest(
    applicationName: ApplicationName,
    terminateEnvByForce: Option[TerminateEnvForce] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        terminateEnvByForce.map(value =>
          TerminateEnvForce.unwrap(value): java.lang.Boolean
        )
      )(_.terminateEnvByForce)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeleteApplicationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DeleteApplicationRequest =
      zio.aws.elasticbeanstalk.model.DeleteApplicationRequest(
        applicationName,
        terminateEnvByForce.map(value => value)
      )
    def applicationName: ApplicationName
    def terminateEnvByForce: Option[TerminateEnvForce]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTerminateEnvByForce: ZIO[Any, AwsError, TerminateEnvForce] =
      AwsError.unwrapOptionField("terminateEnvByForce", terminateEnvByForce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest
  ) extends zio.aws.elasticbeanstalk.model.DeleteApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val terminateEnvByForce: Option[TerminateEnvForce] = scala
      .Option(impl.terminateEnvByForce())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.TerminateEnvForce(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest
  ): zio.aws.elasticbeanstalk.model.DeleteApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
