package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class StatusCodes(
    status2xx: Option[NullableInteger] = None,
    status3xx: Option[NullableInteger] = None,
    status4xx: Option[NullableInteger] = None,
    status5xx: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes = {
    import StatusCodes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
      .builder()
      .optionallyWith(
        status2xx.map(value => NullableInteger.unwrap(value): Integer)
      )(_.status2xx)
      .optionallyWith(
        status3xx.map(value => NullableInteger.unwrap(value): Integer)
      )(_.status3xx)
      .optionallyWith(
        status4xx.map(value => NullableInteger.unwrap(value): Integer)
      )(_.status4xx)
      .optionallyWith(
        status5xx.map(value => NullableInteger.unwrap(value): Integer)
      )(_.status5xx)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly =
    zio.aws.elasticbeanstalk.model.StatusCodes.wrap(buildAwsValue())
}
object StatusCodes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.StatusCodes =
      zio.aws.elasticbeanstalk.model.StatusCodes(
        status2xx.map(value => value),
        status3xx.map(value => value),
        status4xx.map(value => value),
        status5xx.map(value => value)
      )
    def status2xx: Option[NullableInteger]
    def status3xx: Option[NullableInteger]
    def status4xx: Option[NullableInteger]
    def status5xx: Option[NullableInteger]
    def getStatus2xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status2xx", status2xx)
    def getStatus3xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status3xx", status3xx)
    def getStatus4xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status4xx", status4xx)
    def getStatus5xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status5xx", status5xx)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ) extends zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly {
    override val status2xx: Option[NullableInteger] = scala
      .Option(impl.status2xx())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableInteger(value)
      )
    override val status3xx: Option[NullableInteger] = scala
      .Option(impl.status3xx())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableInteger(value)
      )
    override val status4xx: Option[NullableInteger] = scala
      .Option(impl.status4xx())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableInteger(value)
      )
    override val status5xx: Option[NullableInteger] = scala
      .Option(impl.status5xx())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ): zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly = new Wrapper(impl)
}
