package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionName,
  ConfigurationOptionDefaultValue,
  ConfigurationOptionPossibleValue,
  OptionRestrictionMaxLength,
  UserDefinedOption,
  OptionNamespace,
  ConfigurationOptionSeverity,
  OptionRestrictionMinValue,
  OptionRestrictionMaxValue
}
import scala.jdk.CollectionConverters.*
final case class ConfigurationOptionDescription(
    namespace: Option[OptionNamespace] = None,
    name: Option[ConfigurationOptionName] = None,
    defaultValue: Option[ConfigurationOptionDefaultValue] = None,
    changeSeverity: Option[ConfigurationOptionSeverity] = None,
    userDefined: Option[UserDefinedOption] = None,
    valueType: Option[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
    ] = None,
    valueOptions: Option[Iterable[ConfigurationOptionPossibleValue]] = None,
    minValue: Option[OptionRestrictionMinValue] = None,
    maxValue: Option[OptionRestrictionMaxValue] = None,
    maxLength: Option[OptionRestrictionMaxLength] = None,
    regex: Option[zio.aws.elasticbeanstalk.model.OptionRestrictionRegex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription = {
    import ConfigurationOptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
      .builder()
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        name.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        defaultValue.map(value =>
          ConfigurationOptionDefaultValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        changeSeverity.map(value =>
          ConfigurationOptionSeverity.unwrap(value): java.lang.String
        )
      )(_.changeSeverity)
      .optionallyWith(
        userDefined.map(value =>
          UserDefinedOption.unwrap(value): java.lang.Boolean
        )
      )(_.userDefined)
      .optionallyWith(valueType.map(value => value.unwrap))(_.valueType)
      .optionallyWith(
        valueOptions.map(value =>
          value.map { item =>
            ConfigurationOptionPossibleValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.valueOptions)
      .optionallyWith(
        minValue.map(value => OptionRestrictionMinValue.unwrap(value): Integer)
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value => OptionRestrictionMaxValue.unwrap(value): Integer)
      )(_.maxValue)
      .optionallyWith(
        maxLength.map(value =>
          OptionRestrictionMaxLength.unwrap(value): Integer
        )
      )(_.maxLength)
      .optionallyWith(regex.map(value => value.buildAwsValue()))(_.regex)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription
      .wrap(buildAwsValue())
}
object ConfigurationOptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription =
      zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription(
        namespace.map(value => value),
        name.map(value => value),
        defaultValue.map(value => value),
        changeSeverity.map(value => value),
        userDefined.map(value => value),
        valueType.map(value => value),
        valueOptions.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value),
        maxLength.map(value => value),
        regex.map(value => value.asEditable)
      )
    def namespace: Option[OptionNamespace]
    def name: Option[ConfigurationOptionName]
    def defaultValue: Option[ConfigurationOptionDefaultValue]
    def changeSeverity: Option[ConfigurationOptionSeverity]
    def userDefined: Option[UserDefinedOption]
    def valueType
        : Option[zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType]
    def valueOptions: Option[List[ConfigurationOptionPossibleValue]]
    def minValue: Option[OptionRestrictionMinValue]
    def maxValue: Option[OptionRestrictionMaxValue]
    def maxLength: Option[OptionRestrictionMaxLength]
    def regex
        : Option[zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly]
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultValue: ZIO[Any, AwsError, ConfigurationOptionDefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getChangeSeverity: ZIO[Any, AwsError, ConfigurationOptionSeverity] =
      AwsError.unwrapOptionField("changeSeverity", changeSeverity)
    def getUserDefined: ZIO[Any, AwsError, UserDefinedOption] =
      AwsError.unwrapOptionField("userDefined", userDefined)
    def getValueType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
    ] = AwsError.unwrapOptionField("valueType", valueType)
    def getValueOptions
        : ZIO[Any, AwsError, List[ConfigurationOptionPossibleValue]] =
      AwsError.unwrapOptionField("valueOptions", valueOptions)
    def getMinValue: ZIO[Any, AwsError, OptionRestrictionMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, OptionRestrictionMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMaxLength: ZIO[Any, AwsError, OptionRestrictionMaxLength] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getRegex: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly
    ] = AwsError.unwrapOptionField("regex", regex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ) extends zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly {
    override val namespace: Option[OptionNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val name: Option[ConfigurationOptionName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionName(value)
      )
    override val defaultValue: Option[ConfigurationOptionDefaultValue] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationOptionDefaultValue(value)
      )
    override val changeSeverity: Option[ConfigurationOptionSeverity] = scala
      .Option(impl.changeSeverity())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationOptionSeverity(value)
      )
    override val userDefined: Option[UserDefinedOption] = scala
      .Option(impl.userDefined())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.UserDefinedOption(value)
      )
    override val valueType
        : Option[zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType] =
      scala
        .Option(impl.valueType())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
            .wrap(value)
        )
    override val valueOptions: Option[List[ConfigurationOptionPossibleValue]] =
      scala
        .Option(impl.valueOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives
              .ConfigurationOptionPossibleValue(item)
          }.toList
        )
    override val minValue: Option[OptionRestrictionMinValue] = scala
      .Option(impl.minValue())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .OptionRestrictionMinValue(value)
      )
    override val maxValue: Option[OptionRestrictionMaxValue] = scala
      .Option(impl.maxValue())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .OptionRestrictionMaxValue(value)
      )
    override val maxLength: Option[OptionRestrictionMaxLength] = scala
      .Option(impl.maxLength())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .OptionRestrictionMaxLength(value)
      )
    override val regex: Option[
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly
    ] = scala
      .Option(impl.regex())
      .map(value =>
        zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ): zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly =
    new Wrapper(impl)
}
