package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EnvironmentLink(
    linkName: Option[String] = None,
    environmentName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink = {
    import EnvironmentLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink
      .builder()
      .optionallyWith(linkName.map(value => value: java.lang.String))(
        _.linkName
      )
      .optionallyWith(environmentName.map(value => value: java.lang.String))(
        _.environmentName
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentLink.wrap(buildAwsValue())
}
object EnvironmentLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EnvironmentLink =
      zio.aws.elasticbeanstalk.model.EnvironmentLink(
        linkName.map(value => value),
        environmentName.map(value => value)
      )
    def linkName: Option[String]
    def environmentName: Option[String]
    def getLinkName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("linkName", linkName)
    def getEnvironmentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly {
    override val linkName: Option[String] =
      scala.Option(impl.linkName()).map(value => value: String)
    override val environmentName: Option[String] =
      scala.Option(impl.environmentName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink
  ): zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly = new Wrapper(impl)
}
