package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  Token,
  ApplicationName,
  IncludeDeletedBackTo,
  EnvironmentName,
  MaxRecords,
  VersionLabel,
  EnvironmentId,
  IncludeDeleted
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentsRequest(
    applicationName: Option[ApplicationName] = None,
    versionLabel: Option[VersionLabel] = None,
    environmentIds: Option[Iterable[EnvironmentId]] = None,
    environmentNames: Option[Iterable[EnvironmentName]] = None,
    includeDeleted: Option[IncludeDeleted] = None,
    includedDeletedBackTo: Option[IncludeDeletedBackTo] = None,
    maxRecords: Option[MaxRecords] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest = {
    import DescribeEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        environmentIds.map(value =>
          value.map { item =>
            EnvironmentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environmentIds)
      .optionallyWith(
        environmentNames.map(value =>
          value.map { item =>
            EnvironmentName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environmentNames)
      .optionallyWith(
        includeDeleted.map(value =>
          IncludeDeleted.unwrap(value): java.lang.Boolean
        )
      )(_.includeDeleted)
      .optionallyWith(
        includedDeletedBackTo.map(value =>
          IncludeDeletedBackTo.unwrap(value): Instant
        )
      )(_.includedDeletedBackTo)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest(
        applicationName.map(value => value),
        versionLabel.map(value => value),
        environmentIds.map(value => value),
        environmentNames.map(value => value),
        includeDeleted.map(value => value),
        includedDeletedBackTo.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def versionLabel: Option[VersionLabel]
    def environmentIds: Option[List[EnvironmentId]]
    def environmentNames: Option[List[EnvironmentName]]
    def includeDeleted: Option[IncludeDeleted]
    def includedDeletedBackTo: Option[IncludeDeletedBackTo]
    def maxRecords: Option[MaxRecords]
    def nextToken: Option[Token]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getEnvironmentIds: ZIO[Any, AwsError, List[EnvironmentId]] =
      AwsError.unwrapOptionField("environmentIds", environmentIds)
    def getEnvironmentNames: ZIO[Any, AwsError, List[EnvironmentName]] =
      AwsError.unwrapOptionField("environmentNames", environmentNames)
    def getIncludeDeleted: ZIO[Any, AwsError, IncludeDeleted] =
      AwsError.unwrapOptionField("includeDeleted", includeDeleted)
    def getIncludedDeletedBackTo: ZIO[Any, AwsError, IncludeDeletedBackTo] =
      AwsError.unwrapOptionField("includedDeletedBackTo", includedDeletedBackTo)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val environmentIds: Option[List[EnvironmentId]] = scala
      .Option(impl.environmentIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(item)
        }.toList
      )
    override val environmentNames: Option[List[EnvironmentName]] = scala
      .Option(impl.environmentNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(item)
        }.toList
      )
    override val includeDeleted: Option[IncludeDeleted] = scala
      .Option(impl.includeDeleted())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.IncludeDeleted(value)
      )
    override val includedDeletedBackTo: Option[IncludeDeletedBackTo] = scala
      .Option(impl.includedDeletedBackTo())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.IncludeDeletedBackTo(value)
      )
    override val maxRecords: Option[MaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.MaxRecords(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentsRequest.ReadOnly =
    new Wrapper(impl)
}
