package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceQuotas(
    applicationQuota: Option[zio.aws.elasticbeanstalk.model.ResourceQuota] =
      None,
    applicationVersionQuota: Option[
      zio.aws.elasticbeanstalk.model.ResourceQuota
    ] = None,
    environmentQuota: Option[zio.aws.elasticbeanstalk.model.ResourceQuota] =
      None,
    configurationTemplateQuota: Option[
      zio.aws.elasticbeanstalk.model.ResourceQuota
    ] = None,
    customPlatformQuota: Option[zio.aws.elasticbeanstalk.model.ResourceQuota] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas = {
    import ResourceQuotas.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas
      .builder()
      .optionallyWith(applicationQuota.map(value => value.buildAwsValue()))(
        _.applicationQuota
      )
      .optionallyWith(
        applicationVersionQuota.map(value => value.buildAwsValue())
      )(_.applicationVersionQuota)
      .optionallyWith(environmentQuota.map(value => value.buildAwsValue()))(
        _.environmentQuota
      )
      .optionallyWith(
        configurationTemplateQuota.map(value => value.buildAwsValue())
      )(_.configurationTemplateQuota)
      .optionallyWith(customPlatformQuota.map(value => value.buildAwsValue()))(
        _.customPlatformQuota
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly =
    zio.aws.elasticbeanstalk.model.ResourceQuotas.wrap(buildAwsValue())
}
object ResourceQuotas {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ResourceQuotas =
      zio.aws.elasticbeanstalk.model.ResourceQuotas(
        applicationQuota.map(value => value.asEditable),
        applicationVersionQuota.map(value => value.asEditable),
        environmentQuota.map(value => value.asEditable),
        configurationTemplateQuota.map(value => value.asEditable),
        customPlatformQuota.map(value => value.asEditable)
      )
    def applicationQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly]
    def applicationVersionQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly]
    def environmentQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly]
    def configurationTemplateQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly]
    def customPlatformQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly]
    def getApplicationQuota: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly
    ] = AwsError.unwrapOptionField("applicationQuota", applicationQuota)
    def getApplicationVersionQuota: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationVersionQuota",
      applicationVersionQuota
    )
    def getEnvironmentQuota: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly
    ] = AwsError.unwrapOptionField("environmentQuota", environmentQuota)
    def getConfigurationTemplateQuota: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configurationTemplateQuota",
      configurationTemplateQuota
    )
    def getCustomPlatformQuota: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly
    ] = AwsError.unwrapOptionField("customPlatformQuota", customPlatformQuota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas
  ) extends zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly {
    override val applicationQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly] = scala
      .Option(impl.applicationQuota())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(value))
    override val applicationVersionQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly] = scala
      .Option(impl.applicationVersionQuota())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(value))
    override val environmentQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly] = scala
      .Option(impl.environmentQuota())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(value))
    override val configurationTemplateQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly] = scala
      .Option(impl.configurationTemplateQuota())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(value))
    override val customPlatformQuota
        : Option[zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly] = scala
      .Option(impl.customPlatformQuota())
      .map(value => zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas
  ): zio.aws.elasticbeanstalk.model.ResourceQuotas.ReadOnly = new Wrapper(impl)
}
