package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ValidateConfigurationSettingsResponse(
    messages: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ValidationMessage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse = {
    import ValidateConfigurationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
      .builder()
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
      .wrap(buildAwsValue())
}
object ValidateConfigurationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse =
      zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse(
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def messages: Option[
      List[zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly]
    ]
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
  ) extends zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly {
    override val messages: Option[
      List[zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly]
    ] = scala
      .Option(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ValidationMessage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
  ): zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
