package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ForceTerminate,
  TerminateEnvironmentResources,
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class TerminateEnvironmentRequest(
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None,
    terminateResources: Option[TerminateEnvironmentResources] = None,
    forceTerminate: Option[ForceTerminate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest = {
    import TerminateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        terminateResources.map(value =>
          TerminateEnvironmentResources.unwrap(value): java.lang.Boolean
        )
      )(_.terminateResources)
      .optionallyWith(
        forceTerminate.map(value =>
          ForceTerminate.unwrap(value): java.lang.Boolean
        )
      )(_.forceTerminate)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest
      .wrap(buildAwsValue())
}
object TerminateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest =
      zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest(
        environmentId.map(value => value),
        environmentName.map(value => value),
        terminateResources.map(value => value),
        forceTerminate.map(value => value)
      )
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def terminateResources: Option[TerminateEnvironmentResources]
    def forceTerminate: Option[ForceTerminate]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getTerminateResources
        : ZIO[Any, AwsError, TerminateEnvironmentResources] =
      AwsError.unwrapOptionField("terminateResources", terminateResources)
    def getForceTerminate: ZIO[Any, AwsError, ForceTerminate] =
      AwsError.unwrapOptionField("forceTerminate", forceTerminate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ) extends zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly {
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val terminateResources: Option[TerminateEnvironmentResources] =
      scala
        .Option(impl.terminateResources())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .TerminateEnvironmentResources(value)
        )
    override val forceTerminate: Option[ForceTerminate] = scala
      .Option(impl.forceTerminate())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ForceTerminate(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ): zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
