package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{Token, PlatformMaxRecords}
import scala.jdk.CollectionConverters.*
final case class ListPlatformVersionsRequest(
    filters: Option[Iterable[zio.aws.elasticbeanstalk.model.PlatformFilter]] =
      None,
    maxRecords: Option[PlatformMaxRecords] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest = {
    import ListPlatformVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => PlatformMaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest
      .wrap(buildAwsValue())
}
object ListPlatformVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest =
      zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Option[List[zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly]]
    def maxRecords: Option[PlatformMaxRecords]
    def nextToken: Option[Token]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, PlatformMaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.PlatformFilter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[PlatformMaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformMaxRecords(value)
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ): zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
