package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListPlatformVersionsResponse(
    platformSummaryList: Option[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformSummary]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse = {
    import ListPlatformVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
      .builder()
      .optionallyWith(
        platformSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformSummaryList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse
      .wrap(buildAwsValue())
}
object ListPlatformVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse =
      zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse(
        platformSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def platformSummaryList
        : Option[List[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]]
    def nextToken: Option[Token]
    def getPlatformSummaryList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("platformSummaryList", platformSummaryList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly {
    override val platformSummaryList: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]
    ] = scala
      .Option(impl.platformSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ): zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
