package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  EventDate,
  EventMessage,
  VersionLabel,
  PlatformArn,
  RequestId
}
import scala.jdk.CollectionConverters.*
final case class EventDescription(
    eventDate: Option[EventDate] = None,
    message: Option[EventMessage] = None,
    applicationName: Option[ApplicationName] = None,
    versionLabel: Option[VersionLabel] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    environmentName: Option[EnvironmentName] = None,
    platformArn: Option[PlatformArn] = None,
    requestId: Option[RequestId] = None,
    severity: Option[zio.aws.elasticbeanstalk.model.EventSeverity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription = {
    import EventDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
      .builder()
      .optionallyWith(eventDate.map(value => EventDate.unwrap(value): Instant))(
        _.eventDate
      )
      .optionallyWith(
        message.map(value => EventMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EventDescription.wrap(buildAwsValue())
}
object EventDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EventDescription =
      zio.aws.elasticbeanstalk.model.EventDescription(
        eventDate.map(value => value),
        message.map(value => value),
        applicationName.map(value => value),
        versionLabel.map(value => value),
        templateName.map(value => value),
        environmentName.map(value => value),
        platformArn.map(value => value),
        requestId.map(value => value),
        severity.map(value => value)
      )
    def eventDate: Option[EventDate]
    def message: Option[EventMessage]
    def applicationName: Option[ApplicationName]
    def versionLabel: Option[VersionLabel]
    def templateName: Option[ConfigurationTemplateName]
    def environmentName: Option[EnvironmentName]
    def platformArn: Option[PlatformArn]
    def requestId: Option[RequestId]
    def severity: Option[zio.aws.elasticbeanstalk.model.EventSeverity]
    def getEventDate: ZIO[Any, AwsError, EventDate] =
      AwsError.unwrapOptionField("eventDate", eventDate)
    def getMessage: ZIO[Any, AwsError, EventMessage] =
      AwsError.unwrapOptionField("message", message)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EventSeverity] =
      AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ) extends zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly {
    override val eventDate: Option[EventDate] = scala
      .Option(impl.eventDate())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.EventDate(value))
    override val message: Option[EventMessage] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EventMessage(value)
      )
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val requestId: Option[RequestId] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.RequestId(value))
    override val severity
        : Option[zio.aws.elasticbeanstalk.model.EventSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.elasticbeanstalk.model.EventSeverity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ): zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly = new Wrapper(
    impl
  )
}
