package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  SolutionStackName,
  PlatformArn,
  EnvironmentId,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationTemplateRequest(
    applicationName: ApplicationName,
    templateName: ConfigurationTemplateName,
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    sourceConfiguration: Option[
      zio.aws.elasticbeanstalk.model.SourceConfiguration
    ] = None,
    environmentId: Option[EnvironmentId] = None,
    description: Option[Description] = None,
    optionSettings: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = None,
    tags: Option[Iterable[zio.aws.elasticbeanstalk.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest = {
    import CreateConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .templateName(
        ConfigurationTemplateName.unwrap(templateName): java.lang.String
      )
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest =
      zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest(
        applicationName,
        templateName,
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        sourceConfiguration.map(value => value.asEditable),
        environmentId.map(value => value),
        description.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def templateName: ConfigurationTemplateName
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def sourceConfiguration
        : Option[zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly]
    def environmentId: Option[EnvironmentId]
    def description: Option[Description]
    def optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def tags: Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, Nothing, ConfigurationTemplateName] =
      ZIO.succeed(templateName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: ConfigurationTemplateName =
      zio.aws.elasticbeanstalk.model.primitives
        .ConfigurationTemplateName(impl.templateName())
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val sourceConfiguration
        : Option[zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly] =
      scala
        .Option(impl.sourceConfiguration())
        .map(value =>
          zio.aws.elasticbeanstalk.model.SourceConfiguration.wrap(value)
        )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val tags
        : Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ): zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
