package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  PlatformArn,
  UpdateDate,
  Description,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class ConfigurationSettingsDescription(
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    applicationName: Option[ApplicationName] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    description: Option[Description] = None,
    environmentName: Option[EnvironmentName] = None,
    deploymentStatus: Option[
      zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
    ] = None,
    dateCreated: Option[CreationDate] = None,
    dateUpdated: Option[UpdateDate] = None,
    optionSettings: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription = {
    import ConfigurationSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription
      .builder()
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription
      .wrap(buildAwsValue())
}
object ConfigurationSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription =
      zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription(
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        applicationName.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        environmentName.map(value => value),
        deploymentStatus.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def applicationName: Option[ApplicationName]
    def templateName: Option[ConfigurationTemplateName]
    def description: Option[Description]
    def environmentName: Option[EnvironmentName]
    def deploymentStatus
        : Option[zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus]
    def dateCreated: Option[CreationDate]
    def dateUpdated: Option[UpdateDate]
    def optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getDeploymentStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
    ] = AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription
  ) extends zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly {
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val deploymentStatus
        : Option[zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus] =
      scala
        .Option(impl.deploymentStatus())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
            .wrap(value)
        )
    override val dateCreated: Option[CreationDate] = scala
      .Option(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Option[UpdateDate] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription
  ): zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
