package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApplyEnvironmentManagedActionRequest(
    environmentName: Option[String] = None,
    environmentId: Option[String] = None,
    actionId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest = {
    import ApplyEnvironmentManagedActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
      .builder()
      .optionallyWith(environmentName.map(value => value: java.lang.String))(
        _.environmentName
      )
      .optionallyWith(environmentId.map(value => value: java.lang.String))(
        _.environmentId
      )
      .actionId(actionId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
      .wrap(buildAwsValue())
}
object ApplyEnvironmentManagedActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest =
      zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest(
        environmentName.map(value => value),
        environmentId.map(value => value),
        actionId
      )
    def environmentName: Option[String]
    def environmentId: Option[String]
    def actionId: String
    def getEnvironmentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getActionId: ZIO[Any, Nothing, String] = ZIO.succeed(actionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
  ) extends zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest.ReadOnly {
    override val environmentName: Option[String] =
      scala.Option(impl.environmentName()).map(value => value: String)
    override val environmentId: Option[String] =
      scala.Option(impl.environmentId()).map(value => value: String)
    override val actionId: String = impl.actionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
  ): zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest.ReadOnly =
    new Wrapper(impl)
}
