package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentManagedActionHistoryResponse(
    managedActionHistoryItems: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse = {
    import DescribeEnvironmentManagedActionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
      .builder()
      .optionallyWith(
        managedActionHistoryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedActionHistoryItems)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse =
      zio.aws.elasticbeanstalk.model
        .DescribeEnvironmentManagedActionHistoryResponse(
          managedActionHistoryItems.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def managedActionHistoryItems: Option[
      List[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly]
    ]
    def nextToken: Option[String]
    def getManagedActionHistoryItems: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "managedActionHistoryItems",
      managedActionHistoryItems
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly {
    override val managedActionHistoryItems: Option[
      List[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly]
    ] = scala
      .Option(impl.managedActionHistoryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
