package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentInfoType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType
}
object EnvironmentInfoType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType
  ): zio.aws.elasticbeanstalk.model.EnvironmentInfoType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.TAIL =>
      val r = tail
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.BUNDLE =>
      val r = bundle
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.EnvironmentInfoType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.UNKNOWN_TO_SDK_VERSION
  }
  case object tail extends zio.aws.elasticbeanstalk.model.EnvironmentInfoType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.TAIL
  }
  case object bundle
      extends zio.aws.elasticbeanstalk.model.EnvironmentInfoType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType.BUNDLE
  }
}
