package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class PlatformBuilder(arn: Optional[ARN] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder = {
    import PlatformBuilder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformBuilder.wrap(buildAwsValue())
}
object PlatformBuilder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformBuilder =
      zio.aws.elasticbeanstalk.model.PlatformBuilder(arn.map(value => value))
    def arn: Optional[ARN]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder
  ) extends zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder
  ): zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly = new Wrapper(impl)
}
