package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.PlatformArn
import scala.jdk.CollectionConverters._
final case class DeletePlatformVersionRequest(
    platformArn: Optional[PlatformArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest = {
    import DeletePlatformVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest
      .builder()
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeletePlatformVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeletePlatformVersionRequest
      .wrap(buildAwsValue())
}
object DeletePlatformVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DeletePlatformVersionRequest =
      zio.aws.elasticbeanstalk.model
        .DeletePlatformVersionRequest(platformArn.map(value => value))
    def platformArn: Optional[PlatformArn]
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.DeletePlatformVersionRequest.ReadOnly {
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest
  ): zio.aws.elasticbeanstalk.model.DeletePlatformVersionRequest.ReadOnly =
    new Wrapper(impl)
}
