package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait SourceRepository {
  def unwrap
      : software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository
}
object SourceRepository {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository
  ): zio.aws.elasticbeanstalk.model.SourceRepository = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.CODE_COMMIT =>
      val r = CodeCommit
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.SourceRepository {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.UNKNOWN_TO_SDK_VERSION
  }
  case object CodeCommit
      extends zio.aws.elasticbeanstalk.model.SourceRepository {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.CODE_COMMIT
  }
  case object S3 extends zio.aws.elasticbeanstalk.model.SourceRepository {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository.S3
  }
}
