package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait ActionHistoryStatus {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus
}
object ActionHistoryStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus
  ): zio.aws.elasticbeanstalk.model.ActionHistoryStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ActionHistoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed
      extends zio.aws.elasticbeanstalk.model.ActionHistoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.COMPLETED
  }
  case object Failed
      extends zio.aws.elasticbeanstalk.model.ActionHistoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.FAILED
  }
  case object Unknown
      extends zio.aws.elasticbeanstalk.model.ActionHistoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus.UNKNOWN
  }
}
