package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class SourceConfiguration(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration = {
    import SourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly =
    zio.aws.elasticbeanstalk.model.SourceConfiguration.wrap(buildAwsValue())
}
object SourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SourceConfiguration =
      zio.aws.elasticbeanstalk.model.SourceConfiguration(
        applicationName.map(value => value),
        templateName.map(value => value)
      )
    def applicationName: Optional[ApplicationName]
    def templateName: Optional[ConfigurationTemplateName]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration
  ) extends zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration
  ): zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
