package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  SearchFilterValue,
  SearchFilterOperator,
  SearchFilterAttribute
}
import scala.jdk.CollectionConverters._
final case class SearchFilter(
    attribute: Optional[SearchFilterAttribute] = Optional.Absent,
    operator: Optional[SearchFilterOperator] = Optional.Absent,
    values: Optional[Iterable[SearchFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter = {
    import SearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
      .builder()
      .optionallyWith(
        attribute.map(value =>
          SearchFilterAttribute.unwrap(value): java.lang.String
        )
      )(_.attribute)
      .optionallyWith(
        operator.map(value =>
          SearchFilterOperator.unwrap(value): java.lang.String
        )
      )(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            SearchFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly =
    zio.aws.elasticbeanstalk.model.SearchFilter.wrap(buildAwsValue())
}
object SearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SearchFilter =
      zio.aws.elasticbeanstalk.model.SearchFilter(
        attribute.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def attribute: Optional[SearchFilterAttribute]
    def operator: Optional[SearchFilterOperator]
    def values: Optional[List[SearchFilterValue]]
    def getAttribute: ZIO[Any, AwsError, SearchFilterAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperator: ZIO[Any, AwsError, SearchFilterOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[SearchFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ) extends zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly {
    override val attribute: Optional[SearchFilterAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SearchFilterAttribute(value)
        )
    override val operator: Optional[SearchFilterOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SearchFilterOperator(value)
        )
    override val values: Optional[List[SearchFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SearchFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ): zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly = new Wrapper(impl)
}
