package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse =
      zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse(
        resourceArn.map(value => value),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Optional[ResourceArn]
    def resourceTags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse
  ) extends zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ResourceArn(value)
      )
    override val resourceTags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse
  ): zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
