package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  Token,
  PlatformBranchMaxRecords
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPlatformBranchesRequest(
    filters: Optional[Iterable[zio.aws.elasticbeanstalk.model.SearchFilter]] =
      Optional.Absent,
    maxRecords: Optional[PlatformBranchMaxRecords] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest = {
    import ListPlatformBranchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => PlatformBranchMaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest
      .wrap(buildAwsValue())
}
object ListPlatformBranchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest =
      zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[List[zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly]]
    def maxRecords: Optional[PlatformBranchMaxRecords]
    def nextToken: Optional[Token]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, PlatformBranchMaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.SearchFilter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[PlatformBranchMaxRecords] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRecords())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .PlatformBranchMaxRecords(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ): zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly =
    new Wrapper(impl)
}
