package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{TagKey, ResourceArn}
import scala.jdk.CollectionConverters._
final case class UpdateTagsForResourceRequest(
    resourceArn: ResourceArn,
    tagsToAdd: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent,
    tagsToRemove: Optional[Iterable[TagKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest = {
    import UpdateTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        tagsToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagsToAdd)
      .optionallyWith(
        tagsToRemove.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagsToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest
      .wrap(buildAwsValue())
}
object UpdateTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest =
      zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest(
        resourceArn,
        tagsToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagsToRemove.map(value => value)
      )
    def resourceArn: ResourceArn
    def tagsToAdd: Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def tagsToRemove: Optional[List[TagKey]]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagsToAdd: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tagsToAdd", tagsToAdd)
    def getTagsToRemove: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("tagsToRemove", tagsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest
  ) extends zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.elasticbeanstalk.model.primitives.ResourceArn(impl.resourceArn())
    override val tagsToAdd
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
    override val tagsToRemove: Optional[List[TagKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest
  ): zio.aws.elasticbeanstalk.model.UpdateTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
