package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.NullableDouble
import scala.jdk.CollectionConverters._
final case class CPUUtilization(
    user: Optional[NullableDouble] = Optional.Absent,
    nice: Optional[NullableDouble] = Optional.Absent,
    system: Optional[NullableDouble] = Optional.Absent,
    idle: Optional[NullableDouble] = Optional.Absent,
    ioWait: Optional[NullableDouble] = Optional.Absent,
    irq: Optional[NullableDouble] = Optional.Absent,
    softIRQ: Optional[NullableDouble] = Optional.Absent,
    privileged: Optional[NullableDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization = {
    import CPUUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
      .builder()
      .optionallyWith(user.map(value => value: java.lang.Double))(_.user)
      .optionallyWith(nice.map(value => value: java.lang.Double))(_.nice)
      .optionallyWith(system.map(value => value: java.lang.Double))(_.system)
      .optionallyWith(idle.map(value => value: java.lang.Double))(_.idle)
      .optionallyWith(ioWait.map(value => value: java.lang.Double))(_.ioWait)
      .optionallyWith(irq.map(value => value: java.lang.Double))(_.irq)
      .optionallyWith(softIRQ.map(value => value: java.lang.Double))(_.softIRQ)
      .optionallyWith(privileged.map(value => value: java.lang.Double))(
        _.privileged
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly =
    zio.aws.elasticbeanstalk.model.CPUUtilization.wrap(buildAwsValue())
}
object CPUUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CPUUtilization =
      zio.aws.elasticbeanstalk.model.CPUUtilization(
        user.map(value => value),
        nice.map(value => value),
        system.map(value => value),
        idle.map(value => value),
        ioWait.map(value => value),
        irq.map(value => value),
        softIRQ.map(value => value),
        privileged.map(value => value)
      )
    def user: Optional[NullableDouble]
    def nice: Optional[NullableDouble]
    def system: Optional[NullableDouble]
    def idle: Optional[NullableDouble]
    def ioWait: Optional[NullableDouble]
    def irq: Optional[NullableDouble]
    def softIRQ: Optional[NullableDouble]
    def privileged: Optional[NullableDouble]
    def getUser: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("user", user)
    def getNice: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("nice", nice)
    def getSystem: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("system", system)
    def getIdle: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("idle", idle)
    def getIoWait: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("ioWait", ioWait)
    def getIrq: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("irq", irq)
    def getSoftIRQ: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("softIRQ", softIRQ)
    def getPrivileged: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("privileged", privileged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ) extends zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly {
    override val user: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => value: NullableDouble)
    override val nice: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.nice())
      .map(value => value: NullableDouble)
    override val system: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.system())
      .map(value => value: NullableDouble)
    override val idle: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.idle())
      .map(value => value: NullableDouble)
    override val ioWait: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.ioWait())
      .map(value => value: NullableDouble)
    override val irq: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.irq())
      .map(value => value: NullableDouble)
    override val softIRQ: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.softIRQ())
      .map(value => value: NullableDouble)
    override val privileged: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: NullableDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ): zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly = new Wrapper(impl)
}
