package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.S3Bucket
import scala.jdk.CollectionConverters._
final case class CreateStorageLocationResponse(
    s3Bucket: Optional[S3Bucket] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse = {
    import CreateStorageLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse
      .wrap(buildAwsValue())
}
object CreateStorageLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse =
      zio.aws.elasticbeanstalk.model
        .CreateStorageLocationResponse(s3Bucket.map(value => value))
    def s3Bucket: Optional[S3Bucket]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse
  ) extends zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly {
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.S3Bucket(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse
  ): zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly =
    new Wrapper(impl)
}
