package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlatformProgrammingLanguage(
    name: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage = {
    import PlatformProgrammingLanguage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage
      .wrap(buildAwsValue())
}
object PlatformProgrammingLanguage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage =
      zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage(
        name.map(value => value),
        version.map(value => value)
      )
    def name: Optional[String]
    def version: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage
  ) extends zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage
  ): zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly =
    new Wrapper(impl)
}
