package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentResourcesResponse(
    environmentResources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse = {
    import DescribeEnvironmentResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
      .builder()
      .optionallyWith(environmentResources.map(value => value.buildAwsValue()))(
        _.environmentResources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse(
        environmentResources.map(value => value.asEditable)
      )
    def environmentResources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly
    ]
    def getEnvironmentResources: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("environmentResources", environmentResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly {
    override val environmentResources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentResources())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
