package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformName,
  PlatformCategory,
  OperatingSystemVersion,
  SolutionStackName,
  SupportedTier,
  PlatformArn,
  UpdateDate,
  Description,
  PlatformLifecycleState,
  SupportedAddon,
  PlatformBranchLifecycleState,
  Maintainer,
  PlatformVersion,
  PlatformOwner,
  OperatingSystemName,
  BranchName,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PlatformDescription(
    platformArn: Optional[PlatformArn] = Optional.Absent,
    platformOwner: Optional[PlatformOwner] = Optional.Absent,
    platformName: Optional[PlatformName] = Optional.Absent,
    platformVersion: Optional[PlatformVersion] = Optional.Absent,
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    platformStatus: Optional[zio.aws.elasticbeanstalk.model.PlatformStatus] =
      Optional.Absent,
    dateCreated: Optional[CreationDate] = Optional.Absent,
    dateUpdated: Optional[UpdateDate] = Optional.Absent,
    platformCategory: Optional[PlatformCategory] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    maintainer: Optional[Maintainer] = Optional.Absent,
    operatingSystemName: Optional[OperatingSystemName] = Optional.Absent,
    operatingSystemVersion: Optional[OperatingSystemVersion] = Optional.Absent,
    programmingLanguages: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage]
    ] = Optional.Absent,
    frameworks: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformFramework]
    ] = Optional.Absent,
    customAmiList: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.CustomAmi]
    ] = Optional.Absent,
    supportedTierList: Optional[Iterable[SupportedTier]] = Optional.Absent,
    supportedAddonList: Optional[Iterable[SupportedAddon]] = Optional.Absent,
    platformLifecycleState: Optional[PlatformLifecycleState] = Optional.Absent,
    platformBranchName: Optional[BranchName] = Optional.Absent,
    platformBranchLifecycleState: Optional[PlatformBranchLifecycleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription = {
    import PlatformDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
      .builder()
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        platformOwner.map(value =>
          PlatformOwner.unwrap(value): java.lang.String
        )
      )(_.platformOwner)
      .optionallyWith(
        platformName.map(value => PlatformName.unwrap(value): java.lang.String)
      )(_.platformName)
      .optionallyWith(
        platformVersion.map(value =>
          PlatformVersion.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(platformStatus.map(value => value.unwrap))(
        _.platformStatus
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        platformCategory.map(value =>
          PlatformCategory.unwrap(value): java.lang.String
        )
      )(_.platformCategory)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        maintainer.map(value => Maintainer.unwrap(value): java.lang.String)
      )(_.maintainer)
      .optionallyWith(
        operatingSystemName.map(value =>
          OperatingSystemName.unwrap(value): java.lang.String
        )
      )(_.operatingSystemName)
      .optionallyWith(
        operatingSystemVersion.map(value =>
          OperatingSystemVersion.unwrap(value): java.lang.String
        )
      )(_.operatingSystemVersion)
      .optionallyWith(
        programmingLanguages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.programmingLanguages)
      .optionallyWith(
        frameworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworks)
      .optionallyWith(
        customAmiList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAmiList)
      .optionallyWith(
        supportedTierList.map(value =>
          value.map { item =>
            SupportedTier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedTierList)
      .optionallyWith(
        supportedAddonList.map(value =>
          value.map { item =>
            SupportedAddon.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedAddonList)
      .optionallyWith(
        platformLifecycleState.map(value =>
          PlatformLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformLifecycleState)
      .optionallyWith(
        platformBranchName.map(value =>
          BranchName.unwrap(value): java.lang.String
        )
      )(_.platformBranchName)
      .optionallyWith(
        platformBranchLifecycleState.map(value =>
          PlatformBranchLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformBranchLifecycleState)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformDescription.wrap(buildAwsValue())
}
object PlatformDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformDescription =
      zio.aws.elasticbeanstalk.model.PlatformDescription(
        platformArn.map(value => value),
        platformOwner.map(value => value),
        platformName.map(value => value),
        platformVersion.map(value => value),
        solutionStackName.map(value => value),
        platformStatus.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        platformCategory.map(value => value),
        description.map(value => value),
        maintainer.map(value => value),
        operatingSystemName.map(value => value),
        operatingSystemVersion.map(value => value),
        programmingLanguages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        frameworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customAmiList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTierList.map(value => value),
        supportedAddonList.map(value => value),
        platformLifecycleState.map(value => value),
        platformBranchName.map(value => value),
        platformBranchLifecycleState.map(value => value)
      )
    def platformArn: Optional[PlatformArn]
    def platformOwner: Optional[PlatformOwner]
    def platformName: Optional[PlatformName]
    def platformVersion: Optional[PlatformVersion]
    def solutionStackName: Optional[SolutionStackName]
    def platformStatus: Optional[zio.aws.elasticbeanstalk.model.PlatformStatus]
    def dateCreated: Optional[CreationDate]
    def dateUpdated: Optional[UpdateDate]
    def platformCategory: Optional[PlatformCategory]
    def description: Optional[Description]
    def maintainer: Optional[Maintainer]
    def operatingSystemName: Optional[OperatingSystemName]
    def operatingSystemVersion: Optional[OperatingSystemVersion]
    def programmingLanguages: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly]
    ]
    def frameworks: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly]
    ]
    def customAmiList
        : Optional[List[zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly]]
    def supportedTierList: Optional[List[SupportedTier]]
    def supportedAddonList: Optional[List[SupportedAddon]]
    def platformLifecycleState: Optional[PlatformLifecycleState]
    def platformBranchName: Optional[BranchName]
    def platformBranchLifecycleState: Optional[PlatformBranchLifecycleState]
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getPlatformOwner: ZIO[Any, AwsError, PlatformOwner] =
      AwsError.unwrapOptionField("platformOwner", platformOwner)
    def getPlatformName: ZIO[Any, AwsError, PlatformName] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getPlatformVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.PlatformStatus] =
      AwsError.unwrapOptionField("platformStatus", platformStatus)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getPlatformCategory: ZIO[Any, AwsError, PlatformCategory] =
      AwsError.unwrapOptionField("platformCategory", platformCategory)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMaintainer: ZIO[Any, AwsError, Maintainer] =
      AwsError.unwrapOptionField("maintainer", maintainer)
    def getOperatingSystemName: ZIO[Any, AwsError, OperatingSystemName] =
      AwsError.unwrapOptionField("operatingSystemName", operatingSystemName)
    def getOperatingSystemVersion: ZIO[Any, AwsError, OperatingSystemVersion] =
      AwsError.unwrapOptionField(
        "operatingSystemVersion",
        operatingSystemVersion
      )
    def getProgrammingLanguages: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("programmingLanguages", programmingLanguages)
    def getFrameworks: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly
    ]] = AwsError.unwrapOptionField("frameworks", frameworks)
    def getCustomAmiList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly
    ]] = AwsError.unwrapOptionField("customAmiList", customAmiList)
    def getSupportedTierList: ZIO[Any, AwsError, List[SupportedTier]] =
      AwsError.unwrapOptionField("supportedTierList", supportedTierList)
    def getSupportedAddonList: ZIO[Any, AwsError, List[SupportedAddon]] =
      AwsError.unwrapOptionField("supportedAddonList", supportedAddonList)
    def getPlatformLifecycleState: ZIO[Any, AwsError, PlatformLifecycleState] =
      AwsError.unwrapOptionField(
        "platformLifecycleState",
        platformLifecycleState
      )
    def getPlatformBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("platformBranchName", platformBranchName)
    def getPlatformBranchLifecycleState
        : ZIO[Any, AwsError, PlatformBranchLifecycleState] =
      AwsError.unwrapOptionField(
        "platformBranchLifecycleState",
        platformBranchLifecycleState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ) extends zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly {
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val platformOwner: Optional[PlatformOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.platformOwner())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformOwner(value)
      )
    override val platformName: Optional[PlatformName] = zio.aws.core.internal
      .optionalFromNullable(impl.platformName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformName(value)
      )
    override val platformVersion: Optional[PlatformVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersion())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformVersion(value)
        )
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val platformStatus
        : Optional[zio.aws.elasticbeanstalk.model.PlatformStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformStatus())
        .map(value => zio.aws.elasticbeanstalk.model.PlatformStatus.wrap(value))
    override val dateCreated: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Optional[UpdateDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val platformCategory: Optional[PlatformCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformCategory())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformCategory(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val maintainer: Optional[Maintainer] = zio.aws.core.internal
      .optionalFromNullable(impl.maintainer())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Maintainer(value))
    override val operatingSystemName: Optional[OperatingSystemName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.OperatingSystemName(value)
        )
    override val operatingSystemVersion: Optional[OperatingSystemVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemVersion())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .OperatingSystemVersion(value)
        )
    override val programmingLanguages: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.programmingLanguages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.wrap(item)
        }.toList
      )
    override val frameworks: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformFramework.wrap(item)
        }.toList
      )
    override val customAmiList
        : Optional[List[zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.CustomAmi.wrap(item)
          }.toList
        )
    override val supportedTierList: Optional[List[SupportedTier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTierList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SupportedTier(item)
          }.toList
        )
    override val supportedAddonList: Optional[List[SupportedAddon]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedAddonList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SupportedAddon(item)
          }.toList
        )
    override val platformLifecycleState: Optional[PlatformLifecycleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformLifecycleState())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .PlatformLifecycleState(value)
        )
    override val platformBranchName: Optional[BranchName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformBranchName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.BranchName(value)
        )
    override val platformBranchLifecycleState
        : Optional[PlatformBranchLifecycleState] = zio.aws.core.internal
      .optionalFromNullable(impl.platformBranchLifecycleState())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .PlatformBranchLifecycleState(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ): zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly = new Wrapper(
    impl
  )
}
