package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.NullableDouble
import scala.jdk.CollectionConverters._
final case class Latency(
    p999: Optional[NullableDouble] = Optional.Absent,
    p99: Optional[NullableDouble] = Optional.Absent,
    p95: Optional[NullableDouble] = Optional.Absent,
    p90: Optional[NullableDouble] = Optional.Absent,
    p85: Optional[NullableDouble] = Optional.Absent,
    p75: Optional[NullableDouble] = Optional.Absent,
    p50: Optional[NullableDouble] = Optional.Absent,
    p10: Optional[NullableDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Latency = {
    import Latency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Latency
      .builder()
      .optionallyWith(p999.map(value => value: java.lang.Double))(_.p999)
      .optionallyWith(p99.map(value => value: java.lang.Double))(_.p99)
      .optionallyWith(p95.map(value => value: java.lang.Double))(_.p95)
      .optionallyWith(p90.map(value => value: java.lang.Double))(_.p90)
      .optionallyWith(p85.map(value => value: java.lang.Double))(_.p85)
      .optionallyWith(p75.map(value => value: java.lang.Double))(_.p75)
      .optionallyWith(p50.map(value => value: java.lang.Double))(_.p50)
      .optionallyWith(p10.map(value => value: java.lang.Double))(_.p10)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Latency.ReadOnly =
    zio.aws.elasticbeanstalk.model.Latency.wrap(buildAwsValue())
}
object Latency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Latency =
      zio.aws.elasticbeanstalk.model.Latency(
        p999.map(value => value),
        p99.map(value => value),
        p95.map(value => value),
        p90.map(value => value),
        p85.map(value => value),
        p75.map(value => value),
        p50.map(value => value),
        p10.map(value => value)
      )
    def p999: Optional[NullableDouble]
    def p99: Optional[NullableDouble]
    def p95: Optional[NullableDouble]
    def p90: Optional[NullableDouble]
    def p85: Optional[NullableDouble]
    def p75: Optional[NullableDouble]
    def p50: Optional[NullableDouble]
    def p10: Optional[NullableDouble]
    def getP999: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p999", p999)
    def getP99: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p99", p99)
    def getP95: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p95", p95)
    def getP90: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p90", p90)
    def getP85: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p85", p85)
    def getP75: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p75", p75)
    def getP50: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p50", p50)
    def getP10: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p10", p10)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ) extends zio.aws.elasticbeanstalk.model.Latency.ReadOnly {
    override val p999: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p999())
      .map(value => value: NullableDouble)
    override val p99: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p99())
      .map(value => value: NullableDouble)
    override val p95: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p95())
      .map(value => value: NullableDouble)
    override val p90: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p90())
      .map(value => value: NullableDouble)
    override val p85: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p85())
      .map(value => value: NullableDouble)
    override val p75: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p75())
      .map(value => value: NullableDouble)
    override val p50: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p50())
      .map(value => value: NullableDouble)
    override val p10: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.p10())
      .map(value => value: NullableDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ): zio.aws.elasticbeanstalk.model.Latency.ReadOnly = new Wrapper(impl)
}
