package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionName,
  OptionNamespace,
  ValidationMessageString
}
import scala.jdk.CollectionConverters._
final case class ValidationMessage(
    message: Optional[ValidationMessageString] = Optional.Absent,
    severity: Optional[zio.aws.elasticbeanstalk.model.ValidationSeverity] =
      Optional.Absent,
    namespace: Optional[OptionNamespace] = Optional.Absent,
    optionName: Optional[ConfigurationOptionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage = {
    import ValidationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage
      .builder()
      .optionallyWith(
        message.map(value =>
          ValidationMessageString.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        optionName.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.optionName)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly =
    zio.aws.elasticbeanstalk.model.ValidationMessage.wrap(buildAwsValue())
}
object ValidationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ValidationMessage =
      zio.aws.elasticbeanstalk.model.ValidationMessage(
        message.map(value => value),
        severity.map(value => value),
        namespace.map(value => value),
        optionName.map(value => value)
      )
    def message: Optional[ValidationMessageString]
    def severity: Optional[zio.aws.elasticbeanstalk.model.ValidationSeverity]
    def namespace: Optional[OptionNamespace]
    def optionName: Optional[ConfigurationOptionName]
    def getMessage: ZIO[Any, AwsError, ValidationMessageString] =
      AwsError.unwrapOptionField("message", message)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ValidationSeverity
    ] = AwsError.unwrapOptionField("severity", severity)
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOptionName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("optionName", optionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage
  ) extends zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly {
    override val message: Optional[ValidationMessageString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ValidationMessageString(value)
        )
    override val severity
        : Optional[zio.aws.elasticbeanstalk.model.ValidationSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ValidationSeverity.wrap(value)
        )
    override val namespace: Optional[OptionNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val optionName: Optional[ConfigurationOptionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationOptionName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage
  ): zio.aws.elasticbeanstalk.model.ValidationMessage.ReadOnly = new Wrapper(
    impl
  )
}
