package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.SourceLocation
import scala.jdk.CollectionConverters._
final case class SourceBuildInformation(
    sourceType: zio.aws.elasticbeanstalk.model.SourceType,
    sourceRepository: zio.aws.elasticbeanstalk.model.SourceRepository,
    sourceLocation: SourceLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation = {
    import SourceBuildInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation
      .builder()
      .sourceType(sourceType.unwrap)
      .sourceRepository(sourceRepository.unwrap)
      .sourceLocation(SourceLocation.unwrap(sourceLocation): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly =
    zio.aws.elasticbeanstalk.model.SourceBuildInformation.wrap(buildAwsValue())
}
object SourceBuildInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SourceBuildInformation =
      zio.aws.elasticbeanstalk.model
        .SourceBuildInformation(sourceType, sourceRepository, sourceLocation)
    def sourceType: zio.aws.elasticbeanstalk.model.SourceType
    def sourceRepository: zio.aws.elasticbeanstalk.model.SourceRepository
    def sourceLocation: SourceLocation
    def getSourceType
        : ZIO[Any, Nothing, zio.aws.elasticbeanstalk.model.SourceType] =
      ZIO.succeed(sourceType)
    def getSourceRepository
        : ZIO[Any, Nothing, zio.aws.elasticbeanstalk.model.SourceRepository] =
      ZIO.succeed(sourceRepository)
    def getSourceLocation: ZIO[Any, Nothing, SourceLocation] =
      ZIO.succeed(sourceLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation
  ) extends zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly {
    override val sourceType: zio.aws.elasticbeanstalk.model.SourceType =
      zio.aws.elasticbeanstalk.model.SourceType.wrap(impl.sourceType())
    override val sourceRepository
        : zio.aws.elasticbeanstalk.model.SourceRepository =
      zio.aws.elasticbeanstalk.model.SourceRepository
        .wrap(impl.sourceRepository())
    override val sourceLocation: SourceLocation =
      zio.aws.elasticbeanstalk.model.primitives
        .SourceLocation(impl.sourceLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation
  ): zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly =
    new Wrapper(impl)
}
