package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationResourceLifecycleConfig(
    serviceRole: Optional[String] = Optional.Absent,
    versionLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig = {
    import ApplicationResourceLifecycleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
      .builder()
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(
        versionLifecycleConfig.map(value => value.buildAwsValue())
      )(_.versionLifecycleConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
      .wrap(buildAwsValue())
}
object ApplicationResourceLifecycleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig =
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig(
        serviceRole.map(value => value),
        versionLifecycleConfig.map(value => value.asEditable)
      )
    def serviceRole: Optional[String]
    def versionLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ]
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getVersionLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "versionLifecycleConfig",
      versionLifecycleConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ) extends zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly {
    override val serviceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: String)
    override val versionLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ): zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly =
    new Wrapper(impl)
}
