package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters._
final case class SwapEnvironmentCnamEsRequest(
    sourceEnvironmentId: Option[EnvironmentId] = None,
    sourceEnvironmentName: Option[EnvironmentName] = None,
    destinationEnvironmentId: Option[EnvironmentId] = None,
    destinationEnvironmentName: Option[EnvironmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest = {
    import SwapEnvironmentCnamEsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest
      .builder()
      .optionallyWith(
        sourceEnvironmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.sourceEnvironmentId)
      .optionallyWith(
        sourceEnvironmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.sourceEnvironmentName)
      .optionallyWith(
        destinationEnvironmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.destinationEnvironmentId)
      .optionallyWith(
        destinationEnvironmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.destinationEnvironmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest
      .wrap(buildAwsValue())
}
object SwapEnvironmentCnamEsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest =
      zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest(
        sourceEnvironmentId.map(value => value),
        sourceEnvironmentName.map(value => value),
        destinationEnvironmentId.map(value => value),
        destinationEnvironmentName.map(value => value)
      )
    def sourceEnvironmentId: Option[EnvironmentId]
    def sourceEnvironmentName: Option[EnvironmentName]
    def destinationEnvironmentId: Option[EnvironmentId]
    def destinationEnvironmentName: Option[EnvironmentName]
    def getSourceEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("sourceEnvironmentId", sourceEnvironmentId)
    def getSourceEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("sourceEnvironmentName", sourceEnvironmentName)
    def getDestinationEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField(
        "destinationEnvironmentId",
        destinationEnvironmentId
      )
    def getDestinationEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField(
        "destinationEnvironmentName",
        destinationEnvironmentName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest
  ) extends zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest.ReadOnly {
    override val sourceEnvironmentId: Option[EnvironmentId] = scala
      .Option(impl.sourceEnvironmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val sourceEnvironmentName: Option[EnvironmentName] = scala
      .Option(impl.sourceEnvironmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val destinationEnvironmentId: Option[EnvironmentId] = scala
      .Option(impl.destinationEnvironmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val destinationEnvironmentName: Option[EnvironmentName] = scala
      .Option(impl.destinationEnvironmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest
  ): zio.aws.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest.ReadOnly =
    new Wrapper(impl)
}
